/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.ldap.authenticator;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.Authentication;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.ldap.LdapUtils;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.security.providers.encoding.PasswordEncoder;
import org.springframework.security.providers.ldap.authenticator.AbstractLdapAuthenticator;
import org.springframework.security.providers.ldap.authenticator.LdapShaPasswordEncoder;
import org.springframework.security.userdetails.UsernameNotFoundException;
import org.springframework.util.Assert;

public final class PasswordComparisonAuthenticator
extends AbstractLdapAuthenticator {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$providers$ldap$authenticator$PasswordComparisonAuthenticator == null ? (class$org$springframework$security$providers$ldap$authenticator$PasswordComparisonAuthenticator = PasswordComparisonAuthenticator.class$("org.springframework.security.providers.ldap.authenticator.PasswordComparisonAuthenticator")) : class$org$springframework$security$providers$ldap$authenticator$PasswordComparisonAuthenticator));
    private PasswordEncoder passwordEncoder = new LdapShaPasswordEncoder();
    private String passwordAttributeName = "userPassword";
    static /* synthetic */ Class class$org$springframework$security$providers$ldap$authenticator$PasswordComparisonAuthenticator;
    static /* synthetic */ Class class$org$springframework$security$providers$UsernamePasswordAuthenticationToken;

    public PasswordComparisonAuthenticator(BaseLdapPathContextSource contextSource) {
        super((ContextSource)contextSource);
    }

    public DirContextOperations authenticate(Authentication authentication) {
        Assert.isInstanceOf((Class)(class$org$springframework$security$providers$UsernamePasswordAuthenticationToken == null ? (class$org$springframework$security$providers$UsernamePasswordAuthenticationToken = PasswordComparisonAuthenticator.class$("org.springframework.security.providers.UsernamePasswordAuthenticationToken")) : class$org$springframework$security$providers$UsernamePasswordAuthenticationToken), (Object)authentication, (String)"Can only process UsernamePasswordAuthenticationToken objects");
        DirContextOperations user = null;
        String username = authentication.getName();
        String password = (String)authentication.getCredentials();
        Iterator dns = this.getUserDns(username).iterator();
        SpringSecurityLdapTemplate ldapTemplate = new SpringSecurityLdapTemplate(this.getContextSource());
        while (dns.hasNext() && user == null) {
            String userDn = (String)dns.next();
            try {
                user = ldapTemplate.retrieveEntry(userDn, this.getUserAttributes());
            }
            catch (NameNotFoundException ignore) {}
        }
        if (user == null && this.getUserSearch() != null) {
            user = this.getUserSearch().searchForUser(username);
        }
        if (user == null) {
            throw new UsernameNotFoundException("User not found: " + username, username);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Performing LDAP compare of password attribute '" + this.passwordAttributeName + "' for user '" + user.getDn() + "'"));
        }
        String encodedPassword = this.passwordEncoder.encodePassword(password, null);
        byte[] passwordBytes = LdapUtils.getUtf8Bytes(encodedPassword);
        if (!ldapTemplate.compare(user.getDn().toString(), this.passwordAttributeName, passwordBytes)) {
            throw new BadCredentialsException(this.messages.getMessage("PasswordComparisonAuthenticator.badCredentials", "Bad credentials"));
        }
        return user;
    }

    public void setPasswordAttributeName(String passwordAttribute) {
        Assert.hasLength((String)passwordAttribute, (String)"passwordAttributeName must not be empty or null");
        this.passwordAttributeName = passwordAttribute;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        Assert.notNull((Object)passwordEncoder, (String)"passwordEncoder must not be null.");
        this.passwordEncoder = passwordEncoder;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

