/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.fastinfoset;

import com.sun.xml.fastinfoset.stax.StAXDocumentSerializer;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.fastinfoset.FastInfosetMessageFormatter;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FastInfosetPOXMessageFormatter
implements MessageFormatter {
    private static Log logger = LogFactory.getLog(FastInfosetMessageFormatter.class);

    public String formatSOAPAction(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        return null;
    }

    public byte[] getBytes(MessageContext messageContext, OMOutputFormat format) throws AxisFault {
        OMElement element = messageContext.getEnvelope().getBody().getFirstElement();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            StAXDocumentSerializer streamWriter = new StAXDocumentSerializer((OutputStream)outStream);
            streamWriter.writeStartDocument();
            element.serializeAndConsume((XMLStreamWriter)streamWriter);
            streamWriter.writeEndDocument();
            return outStream.toByteArray();
        }
        catch (XMLStreamException xmlse) {
            logger.error((Object)xmlse.getMessage());
            throw new AxisFault(xmlse.getMessage(), (Throwable)xmlse);
        }
    }

    public String getContentType(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        String contentType = (String)messageContext.getProperty("ContentType");
        String encoding = format.getCharSetEncoding();
        if (contentType == null) {
            contentType = (String)messageContext.getProperty("messageType");
        }
        if (encoding != null) {
            contentType = contentType + "; charset=" + encoding;
        }
        return contentType;
    }

    public URL getTargetAddress(MessageContext messageContext, OMOutputFormat format, URL targetURL) throws AxisFault {
        String param;
        String httpMethod = (String)messageContext.getProperty("HTTP_METHOD");
        URL targetAddress = targetURL;
        if (httpMethod != null && "GET".equalsIgnoreCase(httpMethod) && (param = this.getParam(messageContext)).length() > 0) {
            String returnURLFile = targetURL.getFile() + "?" + param;
            try {
                targetAddress = new URL(targetURL.getProtocol(), targetURL.getHost(), targetURL.getPort(), returnURLFile);
            }
            catch (MalformedURLException murle) {
                logger.error((Object)murle.getMessage());
                throw new AxisFault(murle.getMessage(), (Throwable)murle);
            }
        }
        return targetAddress;
    }

    public void writeTo(MessageContext messageContext, OMOutputFormat format, OutputStream outputStream, boolean preserve) throws AxisFault {
        OMElement element = messageContext.getEnvelope().getBody().getFirstElement();
        try {
            StAXDocumentSerializer streamWriter = new StAXDocumentSerializer(outputStream);
            streamWriter.writeStartDocument();
            if (preserve) {
                element.serialize((XMLStreamWriter)streamWriter);
            } else {
                element.serializeAndConsume((XMLStreamWriter)streamWriter);
            }
            streamWriter.writeEndDocument();
        }
        catch (XMLStreamException xmlse) {
            logger.error((Object)xmlse.getMessage());
            throw new AxisFault(xmlse.getMessage(), (Throwable)xmlse);
        }
    }

    private String getParam(MessageContext messageContext) {
        OMElement dataOut = messageContext.getEnvelope().getBody().getFirstElement();
        Iterator it = dataOut.getChildElements();
        StringBuffer paramBuffer = new StringBuffer();
        while (it.hasNext()) {
            OMElement element = (OMElement)it.next();
            String parameter = element.getLocalName() + "=" + element.getText();
            paramBuffer.append(parameter);
            paramBuffer.append("&");
        }
        paramBuffer.deleteCharAt(paramBuffer.length() - 1);
        return paramBuffer.toString();
    }
}

