/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el.impl;

import com.sun.faces.el.impl.ElException;
import com.sun.faces.el.impl.Expression;
import com.sun.faces.el.impl.ExpressionInfo;
import com.sun.faces.el.impl.StringLiteral;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.VariableResolver;

public class NamedValue
extends Expression {
    String mName;

    public String getName() {
        return this.mName;
    }

    public NamedValue(String pName) {
        this.mName = pName;
    }

    public String getExpressionString() {
        return StringLiteral.toIdentifierToken(this.mName);
    }

    public Object evaluate(ExpressionInfo exprInfo) throws ElException {
        VariableResolver resolver = exprInfo.getVariableResolver();
        FacesContext context = exprInfo.getFacesContext();
        if (resolver == null) {
            return null;
        }
        return resolver.resolveVariable(context, this.mName);
    }

    public void setValue(ExpressionInfo exprInfo, Object newValue) throws ElException {
        this.evaluate(exprInfo);
        ExternalContext ec = exprInfo.getFacesContext().getExternalContext();
        if (ec.getRequestMap().get(this.mName) != null) {
            ec.getRequestMap().put(this.mName, newValue);
        } else if (ec.getSessionMap() != null && ec.getSessionMap().get(this.mName) != null) {
            ec.getSessionMap().put(this.mName, newValue);
        } else if (ec.getApplicationMap().get(this.mName) != null) {
            ec.getApplicationMap().put(this.mName, newValue);
        } else {
            ec.getRequestMap().put(this.mName, newValue);
        }
    }

    public boolean isReadOnly(ExpressionInfo exprInfo) throws ElException {
        boolean isReadOnly = false;
        if ("param".equals(this.mName) || "paramValues".equals(this.mName) || "header".equals(this.mName) || "headerValues".equals(this.mName) || "cookie".equals(this.mName) || "initParam".equals(this.mName)) {
            isReadOnly = true;
        }
        return isReadOnly;
    }

    public Class getType(ExpressionInfo exprInfo) throws ElException {
        Class<?> type = null;
        VariableResolver resolver = exprInfo.getVariableResolver();
        FacesContext context = exprInfo.getFacesContext();
        if (resolver != null) {
            Object o = resolver.resolveVariable(context, this.mName);
            type = o != null ? o.getClass() : null;
        }
        return type;
    }
}

