/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.push.server;

import com.icesoft.faces.webapp.xmlhttp.Response;
import com.icesoft.net.messaging.AbstractMessageHandler;
import com.icesoft.net.messaging.Message;
import com.icesoft.net.messaging.MessageHandler;
import com.icesoft.net.messaging.MessageSelector;
import com.icesoft.net.messaging.TextMessage;
import com.icesoft.net.messaging.expression.And;
import com.icesoft.net.messaging.expression.Container;
import com.icesoft.net.messaging.expression.Equal;
import com.icesoft.net.messaging.expression.Expression;
import com.icesoft.net.messaging.expression.Identifier;
import com.icesoft.net.messaging.expression.IsNull;
import com.icesoft.net.messaging.expression.Literal;
import com.icesoft.net.messaging.expression.Or;
import com.icesoft.net.messaging.expression.StringLiteral;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResponseMessageHandler
extends AbstractMessageHandler
implements MessageHandler {
    protected static final String MESSAGE_TYPE = "Response";
    private static final Log LOG = LogFactory.getLog((Class)ResponseMessageHandler.class);
    private static MessageSelector messageSelector;

    protected ResponseMessageHandler() {
        super(messageSelector);
    }

    public void handle(Message message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Handling:\r\n\r\n" + message));
        }
        if (message instanceof TextMessage) {
            String _messageBody = ((TextMessage)message).getText();
            int _beginIndex = 0;
            int _endIndex = _messageBody.indexOf(";");
            String _iceFacesId = _messageBody.substring(_beginIndex, _endIndex);
            _beginIndex = _endIndex + 1;
            _endIndex = _messageBody.indexOf(";", _beginIndex);
            String _viewNumber = _messageBody.substring(_beginIndex, _endIndex);
            _beginIndex = _endIndex + 1;
            _endIndex = _messageBody.indexOf(";", _beginIndex);
            long _sequenceNumber = Long.parseLong(_messageBody.substring(_beginIndex, _endIndex));
            _beginIndex = _endIndex + 1;
            MessageHandler.Callback[] _callbacks = this.getCallbacks(message);
            for (int i = 0; i < _callbacks.length; ++i) {
                ((Callback)_callbacks[i]).sendResponse(new Response(_iceFacesId, _viewNumber, _sequenceNumber, _beginIndex != _messageBody.length() ? _messageBody.substring(_beginIndex) : null));
            }
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName();
    }

    static {
        try {
            messageSelector = new MessageSelector((Expression)new And((Expression)new Equal(new Identifier("message_type"), (Literal)new StringLiteral(MESSAGE_TYPE)), (Expression)new Container((Expression)new Or((Expression)new IsNull(new Identifier("destination_nodeAddress")), (Expression)new Equal(new Identifier("destination_nodeAddress"), (Literal)new StringLiteral(InetAddress.getLocalHost().getHostAddress()))))));
        }
        catch (UnknownHostException exception) {
            if (LOG.isFatalEnabled()) {
                LOG.fatal((Object)"Failed to get IP address for localhost!", (Throwable)exception);
            }
            messageSelector = null;
        }
    }

    public static interface Callback
    extends MessageHandler.Callback {
        public void sendResponse(Response var1);
    }
}

