/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.common.ConfigurationException;
import javax.servlet.ServletConfig;

public class ServletConfigConfiguration
extends Configuration {
    private String name;
    private ServletConfig servletConfig;

    public ServletConfigConfiguration(String prefix, ServletConfig servletConfig) {
        this.name = prefix;
        this.servletConfig = servletConfig;
    }

    public String getAttribute(String name) throws ConfigurationException {
        String _name = this.postfixWith(name);
        String _value = this.servletConfig.getInitParameter(_name);
        if (_value == null) {
            throw new ConfigurationException("Cannot find parameter: " + _name);
        }
        return _value;
    }

    public Configuration getChild(String child) throws ConfigurationException {
        String _name = this.postfixWith(child);
        if (this.servletConfig.getInitParameter(_name) == null) {
            throw new ConfigurationException("Cannot find parameter: " + _name);
        }
        return new ServletConfigConfiguration(_name, this.servletConfig);
    }

    public Configuration[] getChildren(String name) throws ConfigurationException {
        return new Configuration[]{this.getChild(name)};
    }

    public String getName() {
        return this.name;
    }

    public String getValue() throws ConfigurationException {
        String _value = this.servletConfig.getInitParameter(this.name);
        if (_value == null) {
            throw new ConfigurationException("Cannot find parameter: " + this.name);
        }
        return _value;
    }

    private String postfixWith(String child) {
        return this.name + '.' + child;
    }
}

