/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.push.server;

import com.icesoft.faces.env.Authorization;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.servlet.PathDispatcher;
import com.icesoft.faces.webapp.http.servlet.PseudoServlet;
import com.icesoft.faces.webapp.http.servlet.ServletConfigConfiguration;
import com.icesoft.faces.webapp.http.servlet.ServletContextConfiguration;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import com.icesoft.net.messaging.MessageServiceAdapter;
import com.icesoft.net.messaging.MessageServiceClient;
import com.icesoft.net.messaging.http.HttpAdapter;
import com.icesoft.util.ServerUtility;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.icefaces.push.server.ProductInfo;
import org.icefaces.push.server.PushServerMessageService;
import org.icefaces.push.server.SessionBoundServlet;
import org.icefaces.push.server.SessionManager;

public class PushServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog((Class)PushServlet.class);
    private final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(10);
    private String localAddress;
    private int localPort;
    private PushServerMessageService pushServerMessageService;
    private PathDispatcher pathDispatcher = new PathDispatcher();
    private ServletContext servletContext;

    public void destroy() {
        super.destroy();
        this.pushServerMessageService.stop();
        this.pushServerMessageService.close();
        this.pathDispatcher.shutdown();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.servletContext = servletConfig.getServletContext();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)new ProductInfo());
        }
        try {
            ServletConfigConfiguration _servletConfigConfiguration = new ServletConfigConfiguration("org.icefaces.push.server", servletConfig);
            ServletContextConfiguration _servletContextConfiguration = new ServletContextConfiguration("com.icesoft.faces", this.servletContext);
            this.pushServerMessageService = new PushServerMessageService(new MessageServiceClient("Push Server MSC", (MessageServiceAdapter)new HttpAdapter(this.servletContext), this.servletContext), this.scheduledThreadPoolExecutor, (Configuration)new ServletContextConfiguration("com.icesoft.net.messaging", this.servletContext));
            this.pushServerMessageService.setUpNow();
            final SessionManager _sessionManager = new SessionManager((Configuration)_servletConfigConfiguration, this.pushServerMessageService);
            SessionDispatcher _sessionDispatcher = new SessionDispatcher(this.servletContext, (Configuration)_servletContextConfiguration){
                private final /* synthetic */ Configuration val$_servletContextConfiguration;
                {
                    this.val$_servletContextConfiguration = configuration;
                    super(x0);
                }

                protected PseudoServlet newServer(HttpSession httpSession, SessionDispatcher.Monitor monitor, Authorization authorization) {
                    return new SessionBoundServlet(PushServlet.this.servletContext, _sessionManager, PushServlet.this.scheduledThreadPoolExecutor, this.val$_servletContextConfiguration, monitor);
                }
            };
            this.pathDispatcher.dispatchOn(".*(block\\/message)", ((HttpAdapter)this.pushServerMessageService.getMessageServiceClient().getMessageServiceAdapter()).getHttpMessagingDispatcher());
            this.pathDispatcher.dispatchOn(".*", (PseudoServlet)_sessionDispatcher);
            this.pushServerMessageService.start();
        }
        catch (Exception exception) {
            LOG.error((Object)"An error occurred while initializing the Push Server!", (Throwable)exception);
        }
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (this.localAddress == null) {
            this.localAddress = ServerUtility.getLocalAddr((HttpServletRequest)httpServletRequest, (ServletContext)this.servletContext);
            this.localPort = ServerUtility.getLocalPort((HttpServletRequest)httpServletRequest, (ServletContext)this.servletContext);
            MessageServiceAdapter adapter = this.pushServerMessageService.getMessageServiceClient().getMessageServiceAdapter();
            if (adapter instanceof HttpAdapter) {
                ((HttpAdapter)adapter).setLocal(this.localAddress, this.localPort);
            }
        }
        try {
            this.pathDispatcher.service(httpServletRequest, httpServletResponse);
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
    }
}

