/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.wsdl20.extensions.http;

import java.net.URI;
import org.apache.woden.ErrorReporter;
import org.apache.woden.wsdl20.WSDLComponent;
import org.apache.woden.wsdl20.extensions.BaseComponentExtensionContext;
import org.apache.woden.wsdl20.extensions.ExtensionProperty;
import org.apache.woden.wsdl20.extensions.http.HTTPAuthenticationScheme;
import org.apache.woden.wsdl20.extensions.http.HTTPConstants;
import org.apache.woden.wsdl20.extensions.http.HTTPEndpointExtensions;
import org.apache.woden.wsdl20.xml.WSDLElement;
import org.apache.woden.xml.HTTPAuthenticationSchemeAttr;
import org.apache.woden.xml.StringAttr;

public class HTTPEndpointExtensionsImpl
extends BaseComponentExtensionContext
implements HTTPEndpointExtensions {
    public HTTPEndpointExtensionsImpl(WSDLComponent parent, URI extNamespace, ErrorReporter errReporter) {
        super(parent, extNamespace, errReporter);
    }

    public ExtensionProperty[] getProperties() {
        return new ExtensionProperty[]{this.getProperty("http authentication scheme"), this.getProperty("http authentication realm")};
    }

    public ExtensionProperty getProperty(String propertyName) {
        if ("http authentication scheme".equals(propertyName)) {
            return this.newExtensionProperty("http authentication scheme", this.getHttpAuthenticationScheme());
        }
        if ("http authentication realm".equals(propertyName)) {
            return this.newExtensionProperty("http authentication realm", this.getHttpAuthenticationRealm());
        }
        return null;
    }

    public HTTPAuthenticationScheme getHttpAuthenticationScheme() {
        HTTPAuthenticationSchemeAttr scheme = (HTTPAuthenticationSchemeAttr)((WSDLElement)this.getParent()).getExtensionAttribute(HTTPConstants.Q_ATTR_AUTHENTICATION_SCHEME);
        return scheme != null ? scheme.getScheme() : null;
    }

    public String getHttpAuthenticationRealm() {
        StringAttr realm = (StringAttr)((WSDLElement)this.getParent()).getExtensionAttribute(HTTPConstants.Q_ATTR_AUTHENTICATION_REALM);
        return realm != null ? realm.getString() : null;
    }
}

