/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.MessageSender;
import org.apache.axis2.clustering.configuration.ConfigurationClusteringCommand;
import org.apache.axis2.clustering.configuration.ConfigurationManager;
import org.apache.axis2.clustering.configuration.ConfigurationManagerListener;
import org.apache.axis2.clustering.configuration.commands.ApplyServicePolicyCommand;
import org.apache.axis2.clustering.configuration.commands.CommitCommand;
import org.apache.axis2.clustering.configuration.commands.ExceptionCommand;
import org.apache.axis2.clustering.configuration.commands.LoadServiceGroupsCommand;
import org.apache.axis2.clustering.configuration.commands.PrepareCommand;
import org.apache.axis2.clustering.configuration.commands.ReloadConfigurationCommand;
import org.apache.axis2.clustering.configuration.commands.RollbackCommand;
import org.apache.axis2.clustering.configuration.commands.UnloadServiceGroupsCommand;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultConfigurationManager
implements ConfigurationManager {
    private static final Log log = LogFactory.getLog(DefaultConfigurationManager.class);
    private ConfigurationManagerListener listener;
    private MessageSender sender;
    private ConfigurationContext configurationContext;
    private Map parameters = new HashMap();

    public void setConfigurationManagerListener(ConfigurationManagerListener listener) {
        if (this.configurationContext != null) {
            listener.setConfigurationContext(this.configurationContext);
        }
        this.listener = listener;
    }

    public void applyPolicy(String serviceGroupName, String policy) throws ClusteringFault {
        log.debug((Object)"Enter: DefaultConfigurationManager::applyPolicy");
        ApplyServicePolicyCommand command = new ApplyServicePolicyCommand();
        command.setServiceName(serviceGroupName);
        command.setPolicy(policy);
        this.send(command);
        log.debug((Object)"Exit: DefaultConfigurationManager::applyPolicy");
    }

    public void commit() throws ClusteringFault {
        CommitCommand command = new CommitCommand();
        this.send(command);
    }

    public void exceptionOccurred(Throwable throwable) throws ClusteringFault {
        this.sender.sendToGroup((ClusteringCommand)new ExceptionCommand(throwable));
    }

    public void loadServiceGroups(String[] serviceGroupNames) throws ClusteringFault {
        log.debug((Object)"Enter: DefaultConfigurationManager::loadServiceGroups");
        LoadServiceGroupsCommand command = new LoadServiceGroupsCommand();
        command.setServiceGroupNames(serviceGroupNames);
        this.send(command);
        log.debug((Object)"Exit: DefaultConfigurationManager::loadServiceGroups");
    }

    public void prepare() throws ClusteringFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: DefaultConfigurationManager::prepare");
        }
        PrepareCommand command = new PrepareCommand();
        this.send(command);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: DefaultConfigurationManager::prepare");
        }
    }

    public void reloadConfiguration() throws ClusteringFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: DefaultConfigurationManager::reloadConfiguration");
        }
        ReloadConfigurationCommand command = new ReloadConfigurationCommand();
        this.send(command);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: DefaultConfigurationManager::reloadConfiguration");
        }
    }

    public void rollback() throws ClusteringFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: DefaultConfigurationManager::rollback");
        }
        RollbackCommand command = new RollbackCommand();
        this.send(command);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: DefaultConfigurationManager::rollback");
        }
    }

    public void unloadServiceGroups(String[] serviceGroupNames) throws ClusteringFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: DefaultConfigurationManager::unloadServiceGroups");
        }
        UnloadServiceGroupsCommand command = new UnloadServiceGroupsCommand();
        command.setServiceGroupNames(serviceGroupNames);
        this.send(command);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: DefaultConfigurationManager::unloadServiceGroups");
        }
    }

    protected void send(Throwable throwable) throws ClusteringFault {
        this.sender.sendToGroup((ClusteringCommand)new ExceptionCommand(throwable));
    }

    protected void send(ConfigurationClusteringCommand command) throws ClusteringFault {
        this.sender.sendToGroup((ClusteringCommand)command);
        this.sender.sendToSelf((ClusteringCommand)command);
    }

    public void setSender(MessageSender sender) {
        this.sender = sender;
    }

    public void process(ConfigurationClusteringCommand command) throws ClusteringFault {
        switch (command.getCommandType()) {
            case 0: {
                this.listener.configurationReloaded(command);
                break;
            }
            case 1: {
                this.listener.serviceGroupsLoaded(command);
                break;
            }
            case 2: {
                this.listener.serviceGroupsUnloaded(command);
                break;
            }
            case 3: {
                this.listener.policyApplied(command);
                break;
            }
            case 4: {
                this.listener.prepareCalled();
                break;
            }
            case 5: {
                this.listener.commitCalled();
                break;
            }
            case 7: {
                this.listener.rollbackCalled();
                break;
            }
            case 6: {
                this.listener.handleException(((ExceptionCommand)command).getException());
                break;
            }
            default: {
                throw new ClusteringFault("Invalid ConfigurationClusteringCommand " + command.getClass().getName());
            }
        }
    }

    public void setConfigurationContext(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
        if (this.listener != null) {
            this.listener.setConfigurationContext(configurationContext);
        }
    }

    public void addParameter(Parameter param) throws AxisFault {
        this.parameters.put(param.getName(), param);
    }

    public void removeParameter(Parameter param) throws AxisFault {
        this.parameters.remove(param.getName());
    }

    public Parameter getParameter(String name) {
        return (Parameter)this.parameters.get(name);
    }

    public ArrayList getParameters() {
        ArrayList list = new ArrayList();
        Iterator iter = this.parameters.keySet().iterator();
        while (iter.hasNext()) {
            list.add(this.parameters.get(iter.next()));
        }
        return list;
    }

    public boolean isParameterLocked(String parameterName) {
        return this.getParameter(parameterName).isLocked();
    }

    public void deserializeParameters(OMElement parameterElement) throws AxisFault {
        throw new UnsupportedOperationException();
    }
}

