/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.outputchart;

import com.icesoft.faces.component.ExtendedAttributeConstants;
import com.icesoft.faces.component.ext.renderkit.FormRenderer;
import com.icesoft.faces.component.outputchart.OutputChart;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import java.beans.Beans;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OutputChartRenderer
extends DomBasicRenderer {
    private static final String[] passThruAttributes = ExtendedAttributeConstants.getAttributes(48);

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Element table;
        OutputChart outputChart = (OutputChart)uiComponent;
        if (!Beans.isDesignTime()) {
            try {
                if (outputChart.getAbstractChart() == null) {
                    outputChart.createAbstractChart();
                    if (outputChart.getType().equalsIgnoreCase(OutputChart.CUSTOM_CHART_TYPE)) {
                        outputChart.evaluateRenderOnSubmit(facesContext);
                    }
                    outputChart.getAbstractChart().encode(facesContext, outputChart);
                } else if (outputChart.evaluateRenderOnSubmit(facesContext).booleanValue()) {
                    outputChart.getAbstractChart().encode(facesContext, outputChart);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        String clientId = outputChart.getClientId(facesContext);
        DOMContext domContext = DOMContext.attachDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        if (!domContext.isInitialized()) {
            table = domContext.createElement("table");
            domContext.setRootNode((Node)table);
            OutputChartRenderer.setRootElementId((FacesContext)facesContext, (Element)table, (UIComponent)uiComponent);
            Element tbody = domContext.createElement("tbody");
            Element tr = domContext.createElement("tr");
            Element td = domContext.createElement("td");
            table.setAttribute("class", outputChart.getStyleClass());
            String style = outputChart.getStyle();
            if (style != null && style.length() > 0) {
                table.setAttribute("style", style);
            } else {
                table.removeAttribute("style");
            }
            table.appendChild(tbody);
            tbody.appendChild(tr);
            tr.appendChild(td);
        }
        table = (Element)domContext.getRootNode();
        FormRenderer.addHiddenField((FacesContext)facesContext, (String)OutputChart.ICE_CHART_COMPONENT);
        Element td = (Element)domContext.getRootNode().getFirstChild().getFirstChild().getFirstChild();
        DOMContext.removeChildren((Node)td);
        PassThruAttributeRenderer.renderHtmlAttributes((FacesContext)facesContext, (UIComponent)uiComponent, (Element)td, (Element)table, (String[])passThruAttributes);
        Element image = domContext.createElement("img");
        image.setAttribute("src", outputChart.getChartURI().getPath());
        td.appendChild(image);
        if (outputChart.isClientSideImageMap()) {
            Element map = domContext.createElement("map");
            map.setAttribute("name", "map" + clientId);
            image.setAttribute("usemap", "#map" + clientId);
            image.setAttribute("border", "0");
            outputChart.generateClientSideImageMap(domContext, map);
            td.appendChild(map);
        }
        domContext.stepOver();
    }
}

