package de.dass_it.vanhelsing.gui;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;

import javax.faces.model.SelectItem;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import de.dass_it.vanhelsing.gui.items.ConcreteUserObjectItem;
import de.dass_it.vanhelsing.gui.items.UserObjectItem;
import de.dass_it.vanhelsing.gui.items.UserObjectItemType;
/**
 * DataTree contains the data tree of a navigation view and the method used by the view regarding the data tree
 * @author tgoecke
 */
//TODO: labeling schema for header nodes
public class DataTree {
	private DefaultTreeModel tree;
	private DefaultMutableTreeNode root;
	private HashMap<String, SelectItem[]> keyValueList;
	
	public DataTree() {}
	/**
	 * creates a new data tree and sets the name value of the root node to the value of argument name
	 * @param name	label of the root node 
	 */
	public void setTree(String name){
		setRoot(new DefaultMutableTreeNode());
		setTree(new DefaultTreeModel(getRoot()));
		UserObjectItemType userType = new UserObjectItemType(getRoot());
		ConcreteUserObjectItem obj = new ConcreteUserObjectItem();
		getRoot().setUserObject(userType);
		userType.setUserObject(obj);
		userType.setLeaf(false);
		obj.setResName(name);
	}

	/**
	 * creates a tree node as a child to the parent node containing the given UserObectItem
	 * @param parent	root node of the created tree node
	 * @param userObject	a user object which implements the UserObjectItem interface, usually a resource type object
	 * @return returns the created node object
	 */
	public DefaultMutableTreeNode createNode(DefaultMutableTreeNode parent, UserObjectItem userObject){
		DefaultMutableTreeNode node = new DefaultMutableTreeNode();
		UserObjectItemType uoit = new UserObjectItemType(node);
		node.setUserObject(uoit);
		uoit.setUserObject(userObject);
		parent.add(node);
		((UserObjectItemType)parent.getUserObject()).setLeaf(false);
		return node;
	}

	/**
	 * replace a tree nodes UserObject
	 * @param node	node object whose userObject will be updated
	 * @param userObject	new UserObject to replace the nodes current UserObject
	 */
	public void updateNode(DefaultMutableTreeNode node, UserObjectItem userObject){
		((UserObjectItemType)node.getUserObject()).setUserObject(userObject);
	}

	/**
	 * retrieves a node by the value of the UserObjects resId
	 * @param id	value to be matched by the returned object	
	 * @return	first node whose UserObject attribute resId matches the argument id
	 */
	public DefaultMutableTreeNode getNodeById(int id){
  		DefaultMutableTreeNode node;
  		int resId = new Integer(id);
  		Enumeration<DefaultMutableTreeNode> e = root.depthFirstEnumeration();
  		
  		while (e.hasMoreElements()){
  			node = e.nextElement();
  			if (resId ==((ConcreteUserObjectItem)(((UserObjectItemType)node.getUserObject()).
  					getUserObject())).getResId()) {
  				return node;
  			}
  		}
  		return null;
	}

	/**
	 * retrieves a node by the value of the UserObjects resName
	 * @param name	string value to be matched by the returned object
	 * @return	first node whose UserObject attribute matches the argument name
	 */
	public DefaultMutableTreeNode getNodeByName(String name){
  		DefaultMutableTreeNode node;
  		Enumeration<DefaultMutableTreeNode> e = root.depthFirstEnumeration();
  		
  		while (e.hasMoreElements()){
  			node = e.nextElement();
  			if (name.equals(((ConcreteUserObjectItem)(((UserObjectItemType)node.getUserObject())
  					.getUserObject())).getResName())) {
  				return node;
  			}
  		}
  		return null;
	}
	
	/**
	 * deletes the given node from the data tree
	 * @param node	the node which is deleted by this operation
	 * @return	node	the deleted node
	 * @throws ConstraintViolationException		if the node has child nodes
	 */
	public DefaultMutableTreeNode deleteNode(DefaultMutableTreeNode node) throws ConstraintViolationException{
		if (node.getChildCount()>0) throw new ConstraintViolationException();
		DefaultMutableTreeNode parent = (DefaultMutableTreeNode) node.getParent();
		parent.remove(node);
		return node;
	}
	
	public void createKeyValueLists(){
		DefaultMutableTreeNode parent;
		DefaultMutableTreeNode node;
		ConcreteUserObjectItem userObject;
		SelectItem[] selItems;
		String key;
		parent = (DefaultMutableTreeNode)tree.getRoot();
		for (int i = 0; i < parent.getChildCount(); i++){
			node = (DefaultMutableTreeNode)parent.getChildAt(i);
			selItems = new SelectItem[node.getChildCount()];
			for (int j = 0; j < node.getChildCount(); j++){
				userObject = (ConcreteUserObjectItem)((DefaultMutableTreeNode)node.getChildAt(j)).getUserObject();
				selItems[j] = new SelectItem(userObject.getResName(), userObject.getResName());
			}
			key = ((ConcreteUserObjectItem)((DefaultMutableTreeNode)node.getChildAt(i)).getUserObject()).getResType();
			keyValueList.put(key, selItems);
		} 
	}
	public SelectItem[] getSelectItem(String type){
		return keyValueList.get(type);
	}
	public DefaultMutableTreeNode getRoot(){
		return root;
	}
	public void setRoot(DefaultMutableTreeNode root){
		this.root = root;
	}
	public DefaultTreeModel getTree() {
		return tree;
	}
	public void setTree(DefaultTreeModel tree) {
		this.tree = tree;
	}
	public void updateUserObjects(){
		DefaultMutableTreeNode parent;
		DefaultMutableTreeNode node;
		parent = (DefaultMutableTreeNode)tree.getRoot();
		ArrayList<ViewItem> viList;
		for(int i = 0; i < parent.getChildCount(); i++){
			node = (DefaultMutableTreeNode)parent.getChildAt(i);
			for (int j = 0; j < node.getChildCount(); j++){
				viList = ((ConcreteUserObjectItem)((UserObjectItemType)node.getUserObject()).getUserObject()).getViewItemList();
				for (ViewItem vi : viList){
					if (vi.getRenderer().equals("selectOneMenu")){
						vi.setKeyValueList(keyValueList.get(vi.getResType()));
					}
				}
			}
		}
	}

	
}
