/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;

public class TreeStructure
implements Serializable {
    ArrayList children = null;
    HashMap facets = null;
    String className = null;
    String id = null;

    public TreeStructure() {
    }

    public TreeStructure(UIComponent component) {
        Util.parameterNonNull(component);
        this.id = component.getId();
        this.className = component.getClass().getName();
    }

    public String getClazzName() {
        return this.className;
    }

    public Iterator getChildren() {
        if (this.children != null) {
            return this.children.iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public Iterator getFacetNames() {
        if (this.facets != null) {
            return this.facets.keySet().iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public void addChild(TreeStructure treeStruct) {
        Util.parameterNonNull(treeStruct);
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(treeStruct);
    }

    public void addFacet(String facetName, TreeStructure treeStruct) {
        Util.parameterNonNull(facetName);
        Util.parameterNonNull(treeStruct);
        if (this.facets == null) {
            this.facets = new HashMap();
        }
        this.facets.put(facetName, treeStruct);
    }

    public TreeStructure getTreeStructureForFacet(String facetName) {
        Util.parameterNonNull(facetName);
        if (this.facets != null) {
            return (TreeStructure)this.facets.get(facetName);
        }
        return null;
    }

    public UIComponent createComponent() {
        UIComponent component = null;
        try {
            Class clazz = Util.loadClass(this.className, this);
            component = (UIComponent)clazz.newInstance();
        }
        catch (Exception e) {
            Object[] params = new Object[]{this.className};
            throw new FacesException(Util.getExceptionMessageString("com.sun.faces.MISSING_CLASS_ERROR", params));
        }
        Util.doAssert(component != null);
        component.setId(this.id);
        return component;
    }
}

