/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.databinding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.namespace.Constants;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.wsdl.databinding.TypeMapper;
import org.apache.axis2.wsdl.databinding.UnmatchedTypeException;
import org.apache.axis2.wsdl.i18n.CodegenMessages;

public abstract class TypeMappingAdapter
implements TypeMapper {
    protected String defaultClassName = OMElement.class.getName();
    protected static final String XSD_SCHEMA_URL = "http://www.w3.org/2001/XMLSchema";
    protected HashMap qName2NameMap = new HashMap();
    protected HashMap qName2ObjectMap = new HashMap();
    protected HashMap qName2StatusMap = new HashMap();
    protected int counter = 0;
    protected List parameterNameList = new ArrayList();
    protected boolean isObject = false;
    protected static final int UPPER_PARAM_LIMIT = 1000;
    private static final String PARAMETER_NAME_SUFFIX = "param";

    public String getTypeMappingName(QName qname) {
        if (qname != null) {
            Object o = this.qName2NameMap.get(qname);
            if (o != null) {
                return (String)o;
            }
            if (Constants.XSD_ANYTYPE.equals(qname) || Constants.XSD_ANY.equals(qname)) {
                return this.defaultClassName;
            }
            if (Constants.XSD_STRING.equals(qname)) {
                return String.class.getName();
            }
            throw new UnmatchedTypeException(CodegenMessages.getMessage("databinding.typemapper.typeunmatched", qname.getLocalPart(), qname.getNamespaceURI()));
        }
        return null;
    }

    public String getParameterName(QName qname) {
        if (this.counter == 1000) {
            this.counter = 0;
        }
        if (qname != null && qname.getLocalPart().length() != 0) {
            String paramName = JavaUtils.xmlNameToJavaIdentifier((String)qname.getLocalPart());
            if (this.parameterNameList.contains(paramName)) {
                paramName = paramName + this.counter++;
            }
            this.parameterNameList.add(paramName);
            return paramName;
        }
        return PARAMETER_NAME_SUFFIX + this.counter++;
    }

    public void addTypeMappingName(QName qname, String value) {
        this.qName2NameMap.put(qname, value);
    }

    public Object getTypeMappingObject(QName qname) {
        return this.qName2ObjectMap.get(qname);
    }

    public Object getQNameToMappingObject(QName qname) {
        return this.qName2NameMap.get(qname);
    }

    public void addTypeMappingObject(QName qname, Object value) {
        this.isObject = true;
        this.qName2ObjectMap.put(qname, value);
    }

    public boolean isObjectMappingPresent() {
        return this.isObject;
    }

    public Map getAllMappedNames() {
        return this.qName2NameMap;
    }

    public Map getAllMappedObjects() {
        return this.qName2ObjectMap;
    }

    public String getDefaultMappingName() {
        return this.defaultClassName;
    }

    public void setDefaultMappingName(String defaultMapping) {
        this.defaultClassName = defaultMapping;
    }

    public void addTypeMappingStatus(QName qName, Object status) {
        this.qName2StatusMap.put(qName, status);
    }

    public Object getTypeMappingStatus(QName qName) {
        return this.qName2StatusMap.get(qName);
    }
}

