#
# spec file for package [spectemplate]
#
# Copyright (c) 2012 dass IT GmbH, Cologne, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via packager@dass-it.de
#
# norootforbuild

Name:           wsusoffline
Group:          System/Management
Version:        7.3.1
%define ver     "731"
Release:        1
Summary:        WSUS Offline Update: download Microsoft updates
License:        GPLv2+
URL:            http://www.wsusoffline.net/
Source:         %{name}_%{version}.orig.tar.gz

BuildRequires:  unzip
Requires:       cabextract dos2unix md5deep xmlstarlet wget
BuildArch:      noarch

%description
"WSUS Offline Update" allows you to download most Microsoft updates and store them localy.
This includes Windows, Office and some extensions like dotnet or Powershell.
After downloading, they can be installed on any Microsoft Windows system without an  Internet connection.
Also unattended/silient installation are possible, so the update be be included easily in a Windows software management system like http://www.opsi.org

%prep
%setup -c


%build



%install
%define DEST_DIR "/var/lib/wsusoffline/"
mkdir -p $RPM_BUILD_ROOT/var/lib/
unzip %{name}%{ver}.zip -d $RPM_BUILD_ROOT/var/lib/
chmod a+x $RPM_BUILD_ROOT/%{DEST_DIR}/sh/*
mkdir -p $RPM_BUILD_ROOT/usr/bin/
ln -s %{DEST_DIR}/sh/DownloadUpdates.sh $RPM_BUILD_ROOT/usr/bin/wsus-download-updates.sh
ln -s %{DEST_DIR}/sh/CreateISOImage.sh $RPM_BUILD_ROOT/usr/bin/wsus-create-iso-image.sh

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root)
%{DEST_DIR}
/usr/bin/wsus-*.sh



%changelog
