#!/usr/bin/perl -w
# automatisches buildskript fuer smartclient
# liest die konfiguration aus der mit -b bergebenen Datei
# $Id: buildall.pl,v 1.3 2002/09/04 12:44:47 pstorz Exp $
use Getopt::Std;

# Programmoptionen: -b (buildlist) 

my $smartclient_root="../../";   # Pfad, zu dem die Pfade in buildlist stehen
my $build = "build.sh";
our ($opt_b);
my @ArrayofBuilds;
getopts('b:');

if (!$opt_b)
{die "usage: buildall.pl -b buildlist\n";
};

(open(BUILDLIST,$opt_b)) || die "Die Buildlist $opt_b  konnte nicht gefunden werden";


while (<BUILDLIST>) #Buildlist parsen
  {
    next if (/^\#.*$/);
#    if (/([\w\/]+)\s*:([\/\w\-\+\.]+)\s+:((\s*\-\-\w*)*)$/)
    if (/(\S+)\s*:(\S+)\s*:(\S+)\s*$/)
      {
	($dir, $arch, $opt) = ($1, $2, $3);
	chomp ($arch);
	@build=($dir, $arch, $opt);
	push @ArrayofBuilds, [@build];
      }
  }



print "What will be done:\n";
print "Path\tDistribution\tBuildoptions\n";
for $i (0 .. $#ArrayofBuilds)
  {
    print("$ArrayofBuilds[$i][0]\t\t$ArrayofBuilds[$i][1]\t\t$ArrayofBuilds[$i][2]\n");
  }
print "\n\n\n ATTENTION: the srpms from the directory external/SuSE  must be built before!\n";
print "to build srpms, goto dir external/SuSE, execute build_srpms.sh script!\n\n\n";
print 'Are the srpms built and all options OK? (y/n)';

$answer =<STDIN>;
chomp ($answer);
if ($answer ne "y") {die("canceled")};

for $i (0 .. $#ArrayofBuilds)
  {
  print("$ArrayofBuilds[$i][0]\t\t$ArrayofBuilds[$i][1]\t\t$ArrayofBuilds[$i][2]\n");
  $mypath = $smartclient_root.$ArrayofBuilds[$i][0];

  if ($ArrayofBuilds[$i][2])
    {
      $ENV{'BUILD_MODE'}=$ArrayofBuilds[$i][2];
    }
  else 
    {
      $ENV{'BUILD_MODE'}="--clean";
    }
  $ENV{'BUILD_DIST'}=$ArrayofBuilds[$i][1];
  $ENV{'BUILD_DIST'}=$ArrayofBuilds[$i][1];
  
#  system "./test.sh";
  $_=$ArrayofBuilds[$i][0];
  print "$_ \n";
  tr/\//\_/;
  $logfilename = $_.".$ArrayofBuilds[$i][1].log";
  print "++++++++++++++++++++++++++++++++++++++++++\n";
  print "executing command: cd $mypath; $build 2>&1 |tee $logfilename\n";
  print "BUILD_DIST ist $ENV{'BUILD_DIST'}\n";
  print "BUILD_MODE ist $ENV{'BUILD_MODE'}\n";
  
  print "writing logfile to $logfilename \n";
  print "++++++++++++++++++++++++++++++++++++++++++\n";
# system "cd $mypath; $build 2>&1 > $logfilename;"
 system "cd $mypath; $build 2>&1 |tee $logfilename;"
}

print "buildall.pl terminated\n";



