#!/usr/bin/perl -w
# automatisches buildskript fuer smartclient-sourcerpms
# liest die konfiguration aus der mit -b bergebenen Datei
# $Id: build_srpms.pl,v 1.2 2002/09/17 10:03:24 pstorz Exp $
# Philipp Storz, SuSE Linux AG 
# pstorz@suse.de
use Getopt::Std;


format TABELLE =
@<<<<<<<<<<<<<<<<<<<<<<<<<< @<<<<<<<<<<<<<<<<<< @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$wert1, $wert2, $wert3
.


# Programmoptionen: -b (buildlist) -x (xterm)

my $smartclient_root="../../";   # Pfad, zu dem die Pfade in buildlist stehen
my $build = "build.sh";
our ($opt_b);
my @ArrayofBuilds;
getopts('b:x');

if (!$opt_b)
{

print "using default buildlist: buildlist_srpms.speed\n\n";
print "other buildlist can be specified with -b buildlist\n\n";
$opt_b = "buildlist_srpms";

};

(open(BUILDLIST,$opt_b)) || die "Die Buildlist $opt_b  konnte nicht gefunden werden";


while (<BUILDLIST>) #Buildlist parsen
  {
    next if (/^\#.*$/);
#    if (/([\w\/]+)\s*:([\/\w\-\+\.]+)\s+:((\s*\-\-\w*)*)$/)
    if (/(\S+)\s*:(\S+)\s*:(\S+)\s*$/)
      {
	($dir, $arch, $opt) = ($1, $2, $3);
	chomp ($arch);
	@build=($dir, $arch, $opt);
	push @ArrayofBuilds, [@build];
      }
  }



print "What will be done:\n\n";
($wert1,$wert2,$wert3)= ("Path","Distribuition","Buildoptions");
$~="TABELLE";
write;
print "\n";
for $i (0 .. $#ArrayofBuilds)
  {
    ($wert1,$wert2,$wert3)= ($ArrayofBuilds[$i][0],$ArrayofBuilds[$i][1],$ArrayofBuilds[$i][2]);
    $~="TABELLE";
    write;
  }
print 'are all options OK? (y/n)';

$answer =<STDIN>;
chomp ($answer);
if ($answer ne "y") {die("canceled")};

#print "erasing old directories\n";
#system "cd ./clean_dirs.sh";


for $i (0 .. $#ArrayofBuilds)
  {
  print("$ArrayofBuilds[$i][0]\t\t$ArrayofBuild[$i][1]\t\t$ArrayofBuilds[$i][2]\n");
  $_ = $smartclient_root.$ArrayofBuilds[$i][0];
  ($mypath,$myrpm) = /(.*)\/(.*\.src\.rpm)/;
  print "mypath: $mypath\n";
  print "myrpm: $myrpm\n";
  print "cleaning old dirs of packet  $myrpm\n";
  system "./clean_dirs.sh $mypath";
}


for $i (0 .. $#ArrayofBuilds)
  {
  print("$ArrayofBuilds[$i][0]\t\t$ArrayofBuilds[$i][1]\t\t$ArrayofBuilds[$i][2]\n");
  $_ = $smartclient_root.$ArrayofBuilds[$i][0];
  ($mypath,$myrpm) = /(.*\/.*)(\.src\.rpm)/;
  print "mypath: $mypath\n";
#  print "myrpm: $myrpm\n";

  print "Unpacking packet $myrpm\n";
  system "./unpack_srpm.sh $_";


  if ($ArrayofBuilds[$i][2])
    {
      $ENV{'BUILD_MODE'}=$ArrayofBuilds[$i][2];
    }
  else 
    {
      $ENV{'BUILD_MODE'}="--clean";
    }
  $ENV{'BUILD_DIST'}=$ArrayofBuilds[$i][1];
  $_=$ArrayofBuilds[$i][0];
  print "$_ \n";
  tr/\//\_/;
  $logfilename = $_.".$ArrayofBuilds[$i][1].log";
  print "++++++++++++++++++++++++++++++++++++++++++\n";
  print "executing command: cd $mypath; $build 2>&1 > $logfilename\n";
  print "BUILD_DIST ist $ENV{'BUILD_DIST'}\n";
  print "BUILD_MODE ist $ENV{'BUILD_MODE'}\n";
  
  print "writing logfile to $logfilename \n\n\n";
  print "you can watch building with following command: \n";
  $workdir=`pwd`;
  chomp $workdir;
  print "less +F $workdir/$mypath/$logfilename\n";
if ($opt_x)
  {
  system "xterm -T \"build log for PACKET: $mypath    ARCH:$ArrayofBuilds[$i][1] \" -e less +F $workdir/$mypath/$logfilename &";
  print "++++++++++++++++++++++++++++++++++++++++++\n";
  $retval = system "cd $mypath; $build >$logfilename 2>&1;";
  }
  else
  {
    $retval = system "cd $mypath; $build |tee $logfilename";
  }
# $retval = system "./exit.sh 2>&1 > $logfilename;";


 if ($retval == 0)
   {
     $ArrayofBuilds[$i][3]= "SUCESS $ArrayofBuilds[$i][0] :";
     print"******                                                      ******\n";
     print"******   building of $ArrayofBuilds[$i][0] SUCCESSFULL:     \n" ;
     print"******                                                      ******\n";
   }
 else
   {
     $ArrayofBuilds[$i][3]="ERROR  $ArrayofBuilds[$i][0] UNSUCCESSFULL:\n";
     print"******                                                      ******\n";
     print"\n\n\nERROR: building of $ArrayofBuilds[$i][0] UNSUCCESSFULL \n";
     print"******                                                      ******\n";
   }

}

print "Building results:\n";


($wert1,$wert2,$wert3)= ("Path","Distribuition","Result");
$~="TABELLE";
write;
print "\n";

for $i (0 .. $#ArrayofBuilds)
  {
    ($wert1,$wert2,$wert3)= ($ArrayofBuilds[$i][0],$ArrayofBuilds[$i][1],$ArrayofBuilds[$i][3]);
    $~="TABELLE";
    write;
#    print("$ArrayofBuilds[$i][0]:Result: $ArrayofBuilds[$i][3]");
  }




print "buildlist_srpms.pl terminated\n";




