'''
Resource Objects
Created on 30.06.2009

@author: hmueller
'''



class Resource(object):
    DIRECTIVE="Resource"
    serial=0

    def __init__(self, level=0,name=None):
        Resource.serial=Resource.serial+1
        self.items = []
        self.comments = []
        self._recurselevel = level
        self.name = name
        self.value = None
        self.id=Resource.serial

    def __str__(self):

        equalsign_hack=[ 'diraddresses', 'ip', 'ipv4' ]

        s = "\n".join(self.comments) 
        indent="  "*self._recurselevel
        s += indent+"# id:"+str(self.id)+"\n"

        if len(self.items)==0:
                return indent+self.name+" = "+self.value+"\n";

        if self.name.lower() in equalsign_hack:
            s += indent+self.name + " = {\n";
        else:
            s += indent+self.name + " {\n"
        for d in self.items:
            s += str(d)
        s += indent+"}\n"
        return s
    
    def add_comment(self, comment):
        if not comment.lstrip().startswith("#"):
            comment = "# " + comment
        self.comments.append(comment)
        
    def add_item(self, item):
        self.items.append(item)

    def add(self,key,value):
        newRes=Resource()
        newRes.name=key
        newRes.value=value
        newRes._recurselevel=self._recurselevel+1
        self.items.append(newRes)

    def getById(self,theid):
        if self.id==theid:
                return self

        for r in self.items:
                result=r.getById(theid)
                if result:
                        return result
        return None

    def getByName(self,name):
        result=[]
        if self.name==name:
                result.append(self)
        for i in self.items:
                r=i.getByName(name)
                if len(r)!=0:
                    for a in r:
                        result.append(a)
        return result
                          
    def getName(self):
        for i in self.items:
            if i.name=="Name":
                return i.value
        return None

class Root(Resource):
    def __str__(self):
	s=""
        for d in self.items:
            s += str(d)
        return s

class Director(Resource):
    DIRECTIVE="Director"
    pass

class Job(Resource):
    DIRECTIVE="Job"

class JobDefs(Resource):
    DIRECTIVE="JobDefs"

class Schedule(Resource):
    DIRECTIVE="Schedule"

class FileSet(Resource):
    DIRECTIVE="FileSet"

class Client(Resource):
    DIRECTIVE="Client"

class Storage(Resource):
    DIRECTIVE="Storage"

class Pool(Resource):
    DIRECTIVE="Pool"

class Catalog(Resource):
   # ITEMS_DIRD = cdef.dird_cat_items
    DIRECTIVE="Catalog" 

class Messages(Resource):
    DIRECTIVE="Messages"

class Console(Resource):
    DIRECTIVE="Console"

class Counter(Resource):
    DIRECTIVE="Counter"

class Device(Resource):
    DIRECTIVE="Device"

class Autochanger(Resource):
    DIRECTIVE="Autochanger"

class FileDaemon(Resource):
    DIRECTIVE="FileDaemon"

__cls = locals().copy()

directives = [v.DIRECTIVE for k,v in __cls.iteritems() 
              if k != "Resource" and getattr(v, "DIRECTIVE", None)]
