package de.dass_it.vanhelsing.gui;

//import org.apache.log4j.Logger;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultMutableTreeNode;
import de.dass_it.vanhelsing.gui.items.*;


/*
 * Helper class to encapsulate all procedure
 * s to work with the tree structure.
 */
public class TreeNavigation extends BeanUtil {
	private DefaultTreeModel tree;
	//private Logger logger = Logger.getLogger(this.getClass());
	public DefaultTreeModel createTree(DefaultMutableTreeNode root, String[] nodes){
		
		tree = new DefaultTreeModel(root);
		for(int i = 0; i< nodes.length; i++){
			addNode(root, nodes[i]);
		}
		
		return tree;
	}
	
	public DefaultMutableTreeNode addNode(DefaultMutableTreeNode parent, String type){
		DefaultMutableTreeNode node = new DefaultMutableTreeNode();
		node.setParent(parent);
		UserObjectItemType userObject = new UserObjectItemType(node);
		type = "de.dass_it.vanhelsing.gui.items." + type + "Item";
		try {
		Class myClass = Class.forName(type);
		UserObjectItem item = (UserObjectItem) myClass.newInstance();
		userObject.setUserObjectItem(item);

		} catch (ClassNotFoundException e){
			System.err.println("Itemclass "+ type +" must be in the classpath");
		} catch (InstantiationException e){
			System.err.println("Class"+type+"must be a concrete class, not an interface or an abstract class");
		} catch (IllegalAccessException e){
			System.err.println("Class" + type + " lacks a no-argument constructor");
		}

		return node;
	}
}
