package de.dass_it.vanhelsing.gui;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;

public class PropertyBundle{
	
	private static ResourceBundle properties;
	private static final String path = "de.dass_it.vanhelsing.gui.messages";

	private static void initialize(){
		Locale l = FacesContext.getCurrentInstance().getViewRoot().getLocale();
		
		if (l == null){
			l = Locale.ENGLISH;
		}
		properties = ResourceBundle.getBundle(path, l);
	}
	public static String getProperty(String key){
		try{
			if (properties == null){
				initialize();
			}
			return properties.getString(key);
		} catch (Exception e) {
			System.err.println(key+" / "+e.toString());
		}
		return null;
	}
	public static String[] getTypeProperties(String partialKey){
		Enumeration<String> keySet = properties.getKeys();
		String key;
		int i = 0;
		ArrayList<String> result = new ArrayList<String>();
		
		while(keySet.hasMoreElements()){
			key = keySet.nextElement();
			if (key.startsWith(partialKey)){
				result.add(getProperty(key));
			}
		}
		result.trimToSize();
		return result.toArray(new String[0]);
	}
}

