package de.dass_it.vanhelsing.gui;

import javax.faces.model.SelectItem;
import de.dass_it.vanhelsing.gui.items.ItemType;
import de.dass_it.vanhelsing.gui.items.UserObjectItem;

public class ViewItem extends ItemType implements UserObjectItem {
	private String key;
	private String keyValue;
	private String inputText;
	private String selectOneMenu;
	private String radioGroup;
	private boolean necessary;
	private String renderer;
	private String dataType;
	private SelectItem[] keyValueList;
	
	public ViewItem(){
		inputText = null;
		selectOneMenu = null;
	}
	
	public boolean isNecessary() {
		return necessary;
	}

	public void setNecessary(boolean necessary) {
		this.necessary = necessary;
	}

	public String getRenderer() {
		return renderer;
	}

	public void setRenderer(String renderer) {
		this.renderer = renderer;
	}

	public String getDataType() {
		return dataType;
	}

	public void setDataType(String dataType) {
		this.dataType = dataType;
	}

	
	//Methoden aus ItemType für die Zuordnung von Änderungen
	public int getResId(){
		return super.getResId();
	}
	public void setResId(int id){
		super.setResId(id);
	}
	public String getResType(){
		return super.getResType();
	}
	public void setResType(String resType){
		super.setResType(resType);
	}
	//eigene Felder für die Tabellenspalten
	public void setKey(String key) {
		this.key = key;
	}

	public String getKey() {
		return key;
	}
	
	public String getKeyValue() {
		return keyValue;
	}

	public void setKeyValue(String keyValue) {
		this.keyValue = keyValue;
	}

	public void setInputText(String inputText) {
		this.inputText = inputText;
	}

	public String getInputText() {
		return inputText;
	}

	public void setSelectOneMenu(String selectOneMenu) {
		this.selectOneMenu = selectOneMenu;
	}

	public String getSelectOneMenu() {
		return selectOneMenu;
	}
	
	//TODO: RendererFlag überarbeiten
	public void setRendererFlag(String r){
		if (r.equals("inputText")) {
			this.inputText = new String("bernd");
			this.selectOneMenu = null;
			this.radioGroup = null;
		}
		if (r.equals("selectOneMenu")){
			this.selectOneMenu = new String("bernd"); //null;
			this.inputText = null; //new String ("bernd");
			this.radioGroup = null;
			//KeyValuesList erzeugen
			keyValueList = new SelectItem[3];
			keyValueList[0] = new SelectItem("keyBernd","valueBernd");
			keyValueList[1] = new SelectItem("keyHorst","valueHorst");
			keyValueList[2] = new SelectItem("keyPeter","valuePeter");
				
			
		}
		if (r.equals("radioGroup")){
			this.radioGroup = new String("bernd");
			this.selectOneMenu = null;
			this.inputText = null;
		}
	}

	public SelectItem[] getKeyValueList() {
		return keyValueList;
	}

	public void setKeyValueList(SelectItem[] keyValueList) {
		this.keyValueList = keyValueList;
	}
}
