package de.dass_it.vanhelsing.gui;

import java.lang.reflect.Method;
import java.util.ArrayList;

import javax.faces.event.ActionEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import de.dass_it.vanhelsing.gui.items.*;
import de.dass_it.www.vanhelsing.*;
import de.dass_it.www.vanhelsing.VanHelsingCallbackHandler.*;
import de.dass_it.www.vanhelsing.VanHelsingStub.*;

/*
 * List all Bacula configuration components by name
 */
public class ConfigurationBean extends TreeNavigation {

	private DefaultTreeModel tree;
	private ArrayList<ViewItem> selectedObject;
	private String selectedId;

	public ConfigurationBean() {
		init();
	}
	private void init(){
		DefaultMutableTreeNode root = new DefaultMutableTreeNode();
		DefaultMutableTreeNode header;
		DefaultMutableTreeNode leaf;
		String type;
		ListResourcesType lrt;
		GetResourceType grt;
		DefaultMutableTreeNode myNode;
		ResourceInfo[] ri;
		SimpleResource sr;
		// ((ClientItem)selectedObject).setName("ClientNameTest");

		Client c = new Client();
		/*String[] nodes = { "Director", "Storage", "Autochanger",
				"Client", "FileSet", "FDClient", "Schedule", "SDStorage",
				"Console", "Catalog", "SDDevice", "Job", "JobDefs", "Messages",
				"Pool" }; */
		// String[] nodes = {"Client"};
		setTree(super.createTree(root, BeanUtil.getProperty("nodes").split(","), "Configuration"));

		// \forall header wird eine ResourceList[] angefragt
		
		for (int i = 0; i < tree.getChildCount(root); i++) {
			header = (DefaultMutableTreeNode) tree.getChild(root, i);
			type = ((UserObjectItemType) header.getUserObject())
					.getUserObject().getResType();
			lrt = new ListResourcesType();
			lrt.setDirector("bacula-dir");
			lrt.setResourceType(type);
			ri = c.getListResources(lrt);
			if (ri == null || ri.length == 0)
				continue;
			for (int j = 0; j < ri.length; j++) {
				// myNode = null;
				myNode = addNode(header, type, ri[j]);
				// Node mit Daten befüllen
				grt = new GetResourceType();
				grt.setDirector(lrt.getDirector());
				grt.setResId(ri[j].getResId());
				sr = c.getSimpleResource(grt);
				myNode = addNode(myNode, type, sr.getResourceAttributeType());
				if (myNode != null) {
					header.add(myNode);
				}
			}
		} 
		/*
		 * for (int i = 0; i < tree.getChildCount(root); i++){ header =
		 * (DefaultMutableTreeNode)tree.getChild(root, i);
		 * 
		 * for (int j = 0; j < tree.getChildCount(header); j++){ leaf =
		 * (DefaultMutableTreeNode)tree.getChild(header, j); type =
		 * ((UserObjectItemType
		 * )leaf.getUserObject()).getUserObject().getResType(); grt = new
		 * GetResourceType(); grt.setDirector("bacula-dir");
		 * grt.setResId(((ItemType
		 * )(((UserObjectItemType)leaf.getUserObject()).getUserObject
		 * ())).getResId()); sr = c.getSimpleResource(grt);
		 * sr.getResourceAttributeType(); myNode = addNode(leaf, type,
		 * sr.getResourceAttributeType()); if (myNode != null){
		 * leaf.add(myNode); }
		 * 
		 * } }
		 */

	}


	public void userObjectItemNodeSelected(ActionEvent ae) {
		DefaultMutableTreeNode node;
		UserObjectItem userObject;
		selectedObject = new ArrayList<ViewItem>();
		String Id = BeanUtil.getRequestParameter("userObject.resId");
		String selected = BeanUtil.getRequestParameter("ice.event.shift");
		node = getNode(Id, tree);
		if (selected.equals("true")){
			((UserObjectItemType)node.getUserObject()).switchSelected();
		}
		String type = ((UserObjectItem) ((UserObjectItemType) node
				.getUserObject()).getUserObject()).getResType();
		String resName = ((ItemType)((UserObjectItem) ((UserObjectItemType) node
				.getUserObject()).getUserObject())).getResName();
		String director = ((ItemType)((UserObjectItem) ((UserObjectItemType) node
				.getUserObject()).getUserObject())).getDirector();
		String classType = "de.dass_it.vanhelsing.gui.items." + type + "Item";
		String accessType = BeanUtil.getAccessType(type.toLowerCase());
		// Daten aus dem UserObjectItem extrahieren
		try {
			UserObjectItem item = ((UserObjectItemType) (node.getUserObject()))
					.getUserObject();
			Class c = ((UserObjectItemType) (node.getUserObject()))
					.getUserObject().getClass();
			Method[] m = c.getDeclaredMethods();
			String keyValue;
			String key;
			ViewItem vi;
			for (Method n : m) {
				if (n.getName().startsWith("get")) {
					keyValue = (String) n.invoke(item, (Object[]) null);
					if (keyValue == null)
						continue;
					key = n.getName().substring(3);
					vi = new ViewItem();
					vi.setResId(new Integer(Id));
					vi.setKey(key);
					vi.setKeyValue(keyValue);
					vi.setResType(type);
					vi.setResName(resName);
					vi.setDirector(director);
					vi.setRendererFlag(BeanUtil.getRenderer(accessType, key));
					vi.setRequired(BeanUtil.getRequired(accessType, key));
					if (vi.getSelectOneMenu() != null){
						DefaultMutableTreeNode[] dmtn = getChildNodes(tree, vi.getKey());
						if (dmtn != null) {
							SelectItem[] si = new SelectItem[dmtn.length];
							String objectType;
							for (int i = 0; i < dmtn.length; i++){
								UserObjectItem nodeObject = ((UserObjectItemType)dmtn[i].getUserObject()).getUserObject();
								objectType = "de.dass_it.vanhelsing.gui.items." + vi.getKey() +"Item";
								Class subClass = Class.forName(objectType);
								Class myClass = nodeObject.getClass().asSubclass(subClass);
								Method o = myClass.getMethod("getName", (Class[])null);
								si[i] = new SelectItem((String)o.invoke(nodeObject, (Object[])null),
										(String)o.invoke(nodeObject, (Object[])null));
								
							}
							vi.setKeyValueList(si);
						}
					}
					selectedObject.add(vi);
				}
				selectedObject.trimToSize();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	private DefaultMutableTreeNode[] getChildNodes(DefaultTreeModel tree2, String key) {
		DefaultMutableTreeNode[] dmtn;
		DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree2.getRoot();
		DefaultMutableTreeNode node;
		for (int i = 0; i< root.getChildCount(); i++){
			node = (DefaultMutableTreeNode)root.getChildAt(i);
			if (((UserObjectItemType)(node.getUserObject())).getUserObject().getResType().equals(key)){
				dmtn = new DefaultMutableTreeNode[node.getChildCount()];
				for (int j = 0; j < node.getChildCount(); j++){
					dmtn[j] = (DefaultMutableTreeNode)node.getChildAt(j);
				}
				return dmtn;
			}
		}
		return null;
	}
	public void newResourceButtonListener(ActionEvent ae){
		DefaultMutableTreeNode node;
		UserObjectItem userObject;
		selectedObject = new ArrayList<ViewItem>();
		String Id = BeanUtil.getRequestParameter("userObject.ResId");
		String shift = BeanUtil.getRequestParameter("ice.event.shift");
		System.err.println(shift);
		if (Id == null){
			return;
		}
		node = getNode(Id, tree);
		String type = ((UserObjectItem) ((UserObjectItemType) node
				.getUserObject()).getUserObject()).getResType();
		ViewItem vi;
		String[] val;
		try{
			String type2 = "de.dass_it.vanhelsing.gui.items." +  type + "Item";
			Class newClass = Class.forName(type2);
			for (Method m : newClass.getDeclaredMethods()){
				if (m.getName().startsWith("get")) {
					vi = new ViewItem();
					vi.setKey(m.getName().substring(3));
					vi.setRendererFlag(BeanUtil.getRenderer(type, vi.getKey()));
					if (vi.getSelectOneMenu() != null){
						DefaultMutableTreeNode[] dmtn = getChildNodes(tree, vi.getKey());
						if (dmtn != null) {
							SelectItem[] si = new SelectItem[dmtn.length];
							String objectType;
							for (int i = 0; i < dmtn.length; i++){
								UserObjectItem nodeObject = ((UserObjectItemType)dmtn[i].getUserObject()).getUserObject();
								objectType = "de.dass_it.vanhelsing.gui.items." + vi.getKey() +"Item";
								Class subClass = Class.forName(objectType);
								Class myClass = nodeObject.getClass().asSubclass(subClass);
								Method o = myClass.getMethod("getName", (Class[])null);
								si[i] = new SelectItem((String)o.invoke(nodeObject, (Object[])null),
										(String)o.invoke(nodeObject, (Object[])null));
								//System.err.println("si[i]"+si[i].getLabel());
								
							}
							vi.setKeyValueList(si);
						}
					}
					if (vi.getInputText() != null){
						vi.setValue(BeanUtil.getProperty("director."+type+"."+vi.getKey()+".def"));
					}
				}
			}
		} catch (Exception e){
			e.printStackTrace();
		}
		
	}
	public void userObjectItemOptionSelected(ValueChangeEvent vce){
		
	}
	
	public void reloadResourceButtonListener(ActionEvent ae){
		init();
	}
	public void deleteResourceButtonListener(ActionEvent ae){
		BeanUtil.setInfoMessage(null, "Diese Methode ist noch nicht implementiert.");
	}
	
	public void saveButtonListener(ActionEvent ae) {
		if (selectedObject == null){
			BeanUtil.setInfoMessage(null, "bitte eine Resource zum Ändern auswählen");
		} else {
			Client c = new Client();
			ResourceInfo ri = new ResourceInfo();
			SetSimpleResourceResponse s2r2;
			ri.setDirector( selectedObject.get(0).getDirector() );
			ri.setResId( selectedObject.get(0).getResId() );
			ri.setResName( selectedObject.get(0).getResName() );
			ri.setResType( selectedObject.get(0).getResType() );
			// ResourceAttribute
			String key, value;
			ResourceAttributeType[] ra = new ResourceAttributeType[selectedObject.size()];
			for (int i = 0; i < selectedObject.size(); i++) {
				key = selectedObject.get(i).getKey();
				value = selectedObject.get(i).getKeyValue();
				ra[i] = new ResourceAttributeType();
				ra[i].setKey(key);
				ra[i].setValue(value);
			}
			ResourceInitialization rinit = new ResourceInitialization();
			rinit.setResInfo(ri);
			rinit.setResAttribute(ra);
			rinit.setReplace(true);
			s2r2 = c.setSimpleResource(rinit);
			System.err.println("Status setSimpleRes: "+s2r2.getStatus());
			BeanUtil.setErrorMessage(null, "Status setSimpleRessource: "+s2r2.getStatus());
			
			/*String status = s2r2.getStatus();
			if (selectedObject.get(0) != null){
				selectedObject.get(0).setResId(s2r2.getResId());
			}*/
			// TODO: write ResId to selectedObject
			// selectedObject.get(0).setResId(grt.getResId());
			// valueChangeEffect.setFired(false);
		}
	}

	public void setTree(DefaultTreeModel tree) {
		this.tree = tree;
	}

	public DefaultTreeModel getTree() {
		return tree;
	}

	public ArrayList<ViewItem> getSelectedObject() {
		return selectedObject;
	}

	public void setSelectedObject(ArrayList<ViewItem> selectedObject) {
		this.selectedObject = selectedObject;
	}
	public int getSelectedId(){
		if (selectedObject != null){
			if (selectedObject.size() > 0){
				return selectedObject.get(0).getResId();
			}
		}
		return -1;
	}

}
