package de.dass_it.vanhelsing.gui;

import de.dass_it.www.vanhelsing.*;
import de.dass_it.www.vanhelsing.VanHelsingCallbackHandler.*;
import de.dass_it.www.vanhelsing.VanHelsingStub.*;
/**
 * Client wraps the access
 * @author tgoecke
 *
 */
public class Client {
	public ResourceInfo[] getListResources(String director, String resource){
		ListResourcesType lrt = new ListResourcesType();
		lrt.setDirector(director);
		lrt.setResourceType(resource);
		return getListResources(lrt);
	}
	public ResourceInfo[] getListResources(ListResourcesType lrt){
		VanHelsingStub stub;
		try {
									 
			stub = getStub();
			
			VanHelsingStub.ListResources req = new VanHelsingStub.ListResources();
			req.setListResources(lrt);
			
			VanHelsingStub.ListResourcesResponse res = stub.listResources(req);
			return (res.getListResourcesResponse()).getResource();
			
		} catch (Exception e){
			System.err.println("getListResources: " + e.toString());
		}
		return new ResourceInfo[0];
	}
	
	public SimpleResource getSimpleResource(String director, int resId){
		GetResourceType grt = new GetResourceType();
		grt.setDirector(director);
		grt.setResId(resId);
		return getSimpleResource(grt);
	}
	public SimpleResource getSimpleResource(GetResourceType grt){
		VanHelsingStub stub;
		try {
			stub = getStub();
			
			VanHelsingStub.GetSimpleResource req = new VanHelsingStub.GetSimpleResource();
			req.setGetSimpleResource(grt);
			
			VanHelsingStub.GetSimpleResourceResponse res = stub.getSimpleResource(req);
			
			SimpleResource sr = new SimpleResource();
			sr.setResourceInfo(res.getResInfo());
			sr.setResourceAttributeType(res.getResAttribute());
			return sr;
			
			
		} catch(Exception e){
			System.err.println("getSR:" + grt.getResId() + ":" + e.toString());
		}
		return new SimpleResource(new ResourceInfo(), new ResourceAttributeType[0]);
	}
	public SetSimpleResourceResponse setSimpleResource(){
		ResourceInitialization ri = new ResourceInitialization();
		return setSimpleResource(ri);
	}
	public SetSimpleResourceResponse setSimpleResource(ResourceInitialization ri){
		VanHelsingStub stub;
		try {
			stub = getStub();
			
			VanHelsingStub.SetSimpleResource req = new VanHelsingStub.SetSimpleResource();
			req.setSetSimpleResource(ri);
			
			VanHelsingStub.SetSimpleResourceResponse res = stub.setSimpleResource(req);
			
			return res;
		} catch (SetSimpleResourceFault1Exception ef1){
			System.err.println("Constraint Violation");
		} catch (SetSimpleResourceFaultException ef){
			System.err.println("Syntax Error");
		} catch (Exception e) {
			System.err.println(e.toString());
		}
		return null;
	}
	
	private VanHelsingStub getStub() throws Exception {
		String url = new String("http://localhost:8080/");
		VanHelsingStub stub = new VanHelsingStub(url);
		stub._getServiceClient().getOptions().setProperty(org.apache.axis2.transport.http.HTTPConstants.CHUNKED, Boolean.FALSE);
		return stub;
	}	
}
