
# $Id: unittests.py 11429 2010-11-01 18:31:49Z pstorz $

import logging
logging.basicConfig(level=logging.ERROR,
                    format='%(asctime)s %(levelname)s \t (%(module)s:%(lineno)d) %(message)s ',
                    #filename='vanHelsing.log',
                    filemode='w')



import nosferatu.bacresources as bacresources
import unittest
import os

class TestSequenceFunctions(unittest.TestCase):

    def setUp(self):
      '''
      setup our test configuration
      '''      
      self.dc = bacresources.DataCenter('regression/dassIT.dmdz')
      print os.getcwdu()
      #configstring = open('regression/bacula-dir.conf').read()
      #self.DirConf = bacresources.DirectorConfig(configstring)
      self.DirConf = self.dc.directors.pop()
      
      print 'cwd: ' + os.getcwd()

    def test_importConfigurationFile(self):
      '''
      try importing a configuration file into a datacenter
      '''
      self.dc.importConfigurationFile('regression/bacula-fd-import.conf', 'filedaemon')
      print self.dc
      for fd in self.dc.filedaemons:
        print fd
      
      
    def test_getname(self):
        # check the getName function on Director Config
        self.name = self.DirConf.getName()
        self.assertEqual(self.name, 'bacula-dir')

    def test_getResourcesListByResType(self):
        for res in self.DirConf.validresourcesset:
          print res, len(self.DirConf.getResourcesListByResType(res))
          
    def test_getResourceByName(self):
      print "starting test_getResourceByName"
      for name in  ['Standard', 'rt-message', 'Daemon', 'Default', 
		'Scratch', 'LTO4Pool', 'Archive', 'FileStoragePool', 
		'TestPool', 'VMImage-Pool', 'Export-VMImage-Pool', 
		'Export-Server-Pool', 'bacula-mon', 'python','WeeklyCycleAfterBackup','ServerJob']:
        print name, self.DirConf.getResourceByName(name).__class__.__name__
      #print self.DirConf.getResourceByName(name)
      
    def test_getReferencingResourcesListForResource(self):
      print "starting test_getReferencingResourcesListForResource"
      for res in self.DirConf.resources:
        #name = res.items_dict['name'].storage.value
        #print name
    #  for name in  ['Standard', 'rt-message', 'Daemon', 'Default', 
    #'Scratch', 'LTO4Pool', 'Archive', 'FileStoragePool', 
    #'TestPool', 'VMImage-Pool', 'Export-VMImage-Pool', 
    #'Export-Server-Pool', 'bacula-mon', 'python','WeeklyCycleAfterBackup']:
        #print name, self.DirConf.getResourceByName(name).__class__.__name__     
        #res = self.DirConf.getResourceByName(name)
        reflist = self.DirConf.getReferencingResourcesListForResource(res)
        print '\n',res.resourcetype, res.items_dict['name'].storage.value,"is referenced", len(reflist),"times:"
        for refres in reflist:
          print refres.resourcetype, refres.items_dict['name'].storage.value
          #print '"'+refres.resourcetype , str(refres.items_dict['name'].storage.value).strip('"') +  '"->"' + res.resourcetype,str(res.items_dict['name'].storage.value).strip('"') + '"'  
    #    print res.items_dict['name'], len(self.DirConf.getReferencingResourcesListForResource(res))
    
    

    
    def test_onlineHelp(self):
      print "starting test_onlineHelp"
      for res in self.DirConf.resources:
        print res.items_dict['name'].storage.value,res.onlinehelpURL
    #def test_selfcheck(self):
    #  pass
    
    #def test_createResource(self):  
    #  pass

#    def test_sample(self):
#        self.assertRaises(ValueError, random.sample, self.seq, 20)
#        for element in random.sample(self.seq, 5):
#            self.assertTrue(element in self.seq)

if __name__ == '__main__':
    unittest.main()

