#!/bin/bash
# create rpm souce tarbz2s from source tree

if [ $# -ne 2 ]
then
    echo "Error in $0 - Invalid Argument Count"
    echo "usage: $0 modulename version"
    exit
fi


MODULENAME=$1
VERSION=$2

mkdir python-${MODULENAME}-${VERSION}
cp -av ../${MODULENAME}/*  python-${MODULENAME}-${VERSION}

# dassmodus package also contains templates
if [ $1 = dassmodus ] 
then
cp -av ../templates  python-${MODULENAME}-${VERSION}
fi 

# copy setup.py file into directory
cp ${MODULENAME}/setup.py python-${MODULENAME}-${VERSION}
# remove svn secific files
find -type d | grep .svn | xargs rm -R
tar cjvf python-${MODULENAME}-${VERSION}.tar.bz2 python-${MODULENAME}-${VERSION}
rm -Rvf python-${MODULENAME}-${VERSION}

