#!/bin/bash
# create rpm souce tarbz2s from source tree

if [ $# -ne 1 ]
then
    echo "Error in $0 - Invalid Argument Count"
    echo "usage: $0 modulename version"
    exit
fi


MODULENAME=nosferatu
VERSION=$1

mkdir python-${MODULENAME}-${VERSION}
cp -av ../${MODULENAME}/*  python-${MODULENAME}-${VERSION}

# copy setup.py file into directory
cp ${MODULENAME}/setup.py python-${MODULENAME}-${VERSION}
# remove svn secific files
find -type d | grep .svn | xargs rm -R

tar cjvf python-${MODULENAME}-${VERSION}.tar.bz2 python-${MODULENAME}-${VERSION}
rm -Rvf python-${MODULENAME}-${VERSION}


MODULENAME=dassmodus
VERSION=$1

mkdir ${MODULENAME}-${VERSION}
cp -av ../${MODULENAME}/* ${MODULENAME}-${VERSION}

# copy setup.py file into directory
cp ${MODULENAME}/setup.py ${MODULENAME}-${VERSION}
# remove svn secific files
find -type d | grep .svn | xargs rm -R

# dassmodus package also contains templates
cp -av ../templates  ${MODULENAME}-${VERSION}

tar cjvf ${MODULENAME}-${VERSION}.tar.bz2 ${MODULENAME}-${VERSION}
rm -Rvf ${MODULENAME}-${VERSION}


