# -*- coding: utf-8 -*-
# $Id: $
#
# automatically generate the database model for web2py 
# from the info we already have for dassModus
#
#
# we do have every information about the bacula configuration files.
# we now have to create the following database model:
# a table for each main configuration file:
# dird_conf,
# filed_conf,
# stored_conf,
# bconsole_conf
#
# in each bacula configuration file, we have two classes of ressources: 
# 1.: Ressources, that can only appear once
#   here, we can just create a reference to a table containing the 
#   configuration options of this ressource.
#  
#
#
# 2.: Ressources, that can appear multiple times
#   we need a table between the bacula configuration and the list of ressources.
#
#   here, we have a link to a list of ressources
#  example: a dird can have multiple client ressources:
#
#
#
#
         

from nosferatu.config_classes import *
from resource import Resource
from nosferatu import prettynames, auto_configrules, auto_types

#single_res=['dir_res']
## this ressource can only appear once in the dir conf
#for res in single_res:
#  print """db.define_table('dird_conf-%s',
#  Field('name','string'),
#  format='%%s(name)s)'
#  """ % (res)

#print """db.define_table('dird_conf',
#  Field('name','string'),"""
#for res in single_res:
#  print "  Field('dird_conf-%s', reference dird_conf-%s)," % (res,res )
#print "  format='%(name)s')"



def item2field(confshort, item, resname):
    # file, run and plugin item names can appear multiple times
    if item.name in MULTIPLE_ALLOWED_ITEMS_SET:
      print "# item %s can appear multiple times" %(item.name)
      refname = item.name
      fieldtype = 'reference %s_conf__%s'  %  ('dird', item.name)
      defaultvalue = 0
      return """  Field('%s','%s', default=%s), """ %(item.name, fieldtype , defaultvalue)
  
  
  
  
  
  
  
  
    if resname == 'inc_options_items':
      if item.name in  auto_types.FS_option_kw:
        fieldtype = 'string'
        defaultvalue = '"' + FS_option_kw[item.name][0] + '"' #"incremental"
        return """  Field('%s','%s', default=%s, 
                  requires=IS_IN_SET(%s)), """ %(item.name, 
                                                 fieldtype , defaultvalue, 
                                                 repr(auto_types.FS_option_kw[item.name]))  
      
    
    if item.name == 'where' : # where cannot be a column name in sqlite
      item.name = 'where_'
    
    if item.name in INTERNALLY_REFERENCED_ITEMS:
      refname = item.name
      if item.name.endswith('pool'):
        refname = 'pool'
      print '### ' + refname
      
      fieldtype = 'reference %s_conf__%s'  %  (confshort,refname)
      defaultvalue = 0
      return """ Field('%s','%s', default=%s), """ %(item.name, fieldtype , defaultvalue)
    
    elif item.name in set(['include', 'exclude']):
      refname = item.name
      fieldtype = 'reference %s_conf__%s_link'  %  ('dird','inc_newinc_items')
      defaultvalue = 0
      return """ Field('%s','%s', default=%s), """ %(item.name, fieldtype , defaultvalue)
    
    elif item.name == 'options':
      refname = item.name
      fieldtype = 'reference %s_conf__%s_link'  %  ('dird','inc_options')
      defaultvalue = 0
      return """ Field('%s','%s', default=%s), """ %(item.name, fieldtype , defaultvalue)
    
    elif item.name == 'runscript':
      refname = item.name
      fieldtype = 'reference %s_conf__%s_link'  %  ('dird','runscript')
      defaultvalue = 0
      return """  Field('%s','%s', default=%s), """ %(item.name, fieldtype , defaultvalue)
      
    
    elif item.name == 'level':
      refname = item.name
      fieldtype = 'string'
      defaultvalue = '"' + auto_types.joblevels[2] + '"' #"incremental"
      return """  Field('%s','%s', default=%s, 
                  requires=IS_IN_SET(%s)), """ %(item.name, 
                                                 fieldtype , defaultvalue, 
                                                 repr(auto_types.joblevels))
    elif item.name == 'type':
      refname = item.name
      fieldtype = 'string'
      defaultvalue = '"' + auto_types.jobtypes[5] + '"' # "backup"
      return """  Field('%s','%s', default=%s, 
                  requires=IS_IN_SET(%s)), """ %(item.name, 
                                                 fieldtype , defaultvalue, 
                                                 repr(auto_types.jobtypes))      
      
    elif item.name == 'replace':
      refname = item.name
      fieldtype = 'string'
      defaultvalue = '"' + auto_types.ReplaceOptions[0] + '"' # "always"
      return """  Field('%s','%s', default=%s, 
                  requires=IS_IN_SET(%s)), """ %(item.name, 
                                                 fieldtype , defaultvalue, 
                                                 repr(auto_types.ReplaceOptions))      
    else:
      fieldtype = 'string'
      defaultvalue = item.defaultvalue
      if defaultvalue == None: 
        defaultvalue = ''
      if item.type == "store_bool":
        fieldtype = "boolean"
        #print "#####%s %s %s" % (item.name, item.defaultvalue, defaultvalue) 
        return """ Field('%s','%s', default=%s), """ %(item.name, fieldtype , defaultvalue)
      return """ Field('%s','%s', default='%s'), """ %(item.name, fieldtype , defaultvalue)




# subressourcen:
# unterhalb von fileset  include und exclude
# unterhalb von include und exclude options
# unterhalb von job runscript



#inc_newinc_items
#inc_options_items
#dird_runscript_items
print "# subressources"


confshort = 'dird'
res_name = 'options'
print """db.define_table('%s_conf__%s',  """ % (confshort,res_name)
for item in auto_configrules.inc_options_items:
    item.required=False
    item.printall=True
    print item2field(confshort,item, res_name)
print """ format='options-%(id)s')
"""
#print """db.define_table('%s_conf__%s_link',  
#  Field('%s','reference %s_conf__%s'),
#  format = '%%(id)s')
#    """ %  (confshort,res_name, res_name, confshort,res_name)


    
for res_name in ('include', 'exclude'):    
  confshort = 'dird'
  #res_name = 'include'
  print """db.define_table('%s_conf__%s',  """ % (confshort,res_name)
  for item in auto_configrules.inc_newinc_items:
    item.required=False
    item.printall=True
    print item2field(confshort,item, res_name)
  print """ format='include-%(id)s')
  """
#  print """db.define_table('%s_conf__%s_link',  
#  Field('%s','reference %s_conf__%s'),
#  format = '%%(id)s')
#    """ %  (confshort,res_name, res_name, confshort,res_name)


#

confshort = 'dird'
res_name = 'dird_runscript_items'
print """db.define_table('%s_conf__%s',  """ % (confshort,res_name)
for item in auto_configrules.dird_runscript_items:
    item.required=False
    item.printall=True
    print item2field(confshort,item, res_name)
print """ format='runscript-%(id)s')
"""
#print """db.define_table('%s_conf__%s_link',  
#  Field('%s','reference %s_conf__%s'),
#  format = '%%(id)s')
#    """ %  (confshort,res_name, res_name, confshort,res_name)


# TODO: folgende linktabellen herstellen
# TODO: include_to_options
# TODO: fileset_to_include
# TODO: fileset_to_exclude
# TODO: job_to_runscript_items


# Anlegen der eigentlichen Speicherplätze für die Ressourcen

dir_res_list = list()
 
confshort = 'dird'
for res in auto_configrules.dird_resources:
  res_name = res[0]
  res_type = res[1]
  res_items = res[2]
  dir_res_list.append(res_name)
  print 
  #print res_name
  print """db.define_table('%s_conf__%s',  """ % (confshort, res_name)
  for item in res_items:
    item.required=False
    item.printall=True
    print item2field(confshort,item, res_name)
  print """ format='%(name)s')"""


confshort = 'stored'
stor_res_list = list()
for res in auto_configrules.stored_resources:
  res_name = res[0]
  res_type = res[1]
  res_items = res[2]
  stor_res_list.append(res_name)
  print 
  #print res_name
  print """db.define_table('%s_conf__%s',  """ % (confshort,res_name)
  for item in res_items:
    item.required=False
    item.printall=True
    print item2field(confshort,item, res_name)
  print """ format='%(name)s')"""


confshort = 'filed'
filed_res_list = list()
for res in auto_configrules.filed_resources:
  res_name = res[0]
  res_type = res[1]
  res_items = res[2]
  filed_res_list.append(res_name)
  print 
  #print res_name
  print """db.define_table('%s_conf__%s',  """ % (confshort,res_name)
  for item in res_items:
    item.required=False
    item.printall=True
    print item2field(confshort,item, res_name)
  print """ format='%(name)s')"""

confshort = 'cons'
cons_res_list = list()
for res in auto_configrules.console_resources:
  res_name = res[0]
  res_type = res[1]
  res_items = res[2]
  cons_res_list.append(res_name)
  print 
  #print res_name
  print """db.define_table('%s_conf__%s',  """ % (confshort,res_name)
  for item in res_items:
    item.required=False
    item.printall=True
    print item2field(confshort,item, res_name)
  print """ format='%(name)s')"""





for confshort  in ['dird','stored','filed','cons']:


  print "\n#the table representing the %s configuration file" % (confshort)

  print """db.define_table('%s_conf',
    Field('name','string'),
    format='%%(name)s') """ % (confshort)

  print "\n#link tables between %s configs and %s config ressources" % (confshort, confshort)

  for res in dir_res_list:   
    print """db.define_table('%s_conf_to_%s',
    Field('%s_conf','reference %s_conf'),
    Field('%s','reference %s_conf__%s'),
    format = '%%(id)s')
    """ % (confshort,res,confshort,confshort,res,confshort,res)






print "# items that can appear multiple times"
confshort = 'dird'
for name in  MULTIPLE_ALLOWED_ITEMS_SET:

  # create the table itself
  print """db.define_table('%s_conf__%s',  
    Field('%s','string', default=''),
  format = '%%(%s)s')
    """ %  (confshort, name, name, name )  
  
  # create the linking tables
  # plugin and file belong to dird_fileset_includes, 
  # runscript belong to job ressource
  if name == 'run':
    parent_res = 'schedule'
  else:
    parent_res = 'include'
    
  print """db.define_table('%s_conf__%s_to_%s_conf__%s',  
    Field('%s_conf__%s','reference %s_conf__%s'),
    Field('%s_conf__%s','reference %s_conf__%s'),
  format = '%%(id)s')
    """ %  (confshort,name,confshort,parent_res,
            confshort,name,confshort,name,
            confshort,parent_res,confshort,parent_res)








#    print """db.define_table('dird_conf_to_%s',
#    Field('dird_conf','reference dird_conf'),
#    Field('%s','reference dird_conf__%s'),
#    format = '%%(id)s')
#    """ % (res,res,res)
    
  
#for res in dir_res_list:
#  print "  Field('dird_conf__%s', 'reference dirs_to_%ss')," % (res,res )
#print """  format='%(name)s')
#"""



#for res in stor_res_list:   
#  print """db.define_table('stord_conf__%s_link',
#  Field('%s','reference stord_conf__%s'),
#  format = '%%(id)s')
#    """ % (res,res,res)
#print """db.define_table('stord_conf',
#  Field('name','string'),"""
#
#for res in stor_res_list:
#  print "  Field('stord_conf__%s', 'reference stord_conf__%s_link')," % (res,res )
#print """  format='%(name)s')
#"""
#
#
#
#for res in filed_res_list:   
#  print """db.define_table('filed_conf__%s_link',
#  Field('%s','reference filed_conf__%s'),
#  format = '%%(id)s')
#    """ % (res,res,res)
#print """db.define_table('filed_conf',
#  Field('name','string'),"""
#
#for res in filed_res_list:
#  print "  Field('filed_conf__%s', 'reference filed_conf__%s_link')," % (res,res )
#print """  format='%(name)s')
#"""
#
#
#
#for res in cons_res_list:   
#  print """db.define_table('cons_conf__%s_link',
#  Field('%s','reference cons_conf__%s'),
#  format = '%%(id)s')
#    """ % (res,res,res)
#print """db.define_table('cons_conf',
#  Field('name','string'),"""
#
#for res in cons_res_list:
#  print "  Field('cons_conf__%s', 'reference cons_conf__%s_link')," % (res,res )
#print """  format='%(name)s')
#"""
#







#Abhängikeiten:
# dird 
#  job/jobdefs   ->client
#                -> pool
#                -> fileset
#                -> pool
#                -> messages
#                -> schedule
#                -> storage
#                -> jobdefs
#                -> job
# messages   -> catalog
# counter    -> catalog
# storage    -> device
# director   -> messages
# client     -> catalog
# pool       -> catalog, storage


# Reihenfolge:
# storage->catalog->fileset->pool->jobdefs->client->
# counter->messages->job->director



# stored:
# autochanger -> device
# storage  -> messages
# messages -> catalog

# filed:
# messages -> catalog
# client/filedaemon -> messages




# Tabellenarchitektur:


# Zur Speicherung der verschiedenen Ressourcentypen benötigen 
# wir jeweils eine Tabelle für jeden Ressourcentyp




# jede Konfigurationsdatei hat wird durch eine Tabelle dargestellt:
#db.dirdconf
#db.consconf
#db.stordconf
#db.filedconf

# da jeder dieser Konfigurationsdateien ressourcen
# enthalten kann, auch unterschiedlichen Typs, 
# enthält jede Konfigdateitabelle einen Verweis auf eine
# Tabelle des jeweiligen ressourcentyps. 
# Diese Tabelle verweist dann auf die eigentlichen Ressourcen:














